﻿unit PosDllDemo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,PosdllFuncs,IniFiles,
  winspool, XPMan;
type
  TMainForm = class(TForm)
    PortSet: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label4: TLabel;
    Label8: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    cbPortName: TComboBox;
    cbBaud: TComboBox;
    cbData: TComboBox;
    cbParity: TComboBox;
    cbStop: TComboBox;
    cbFlow: TComboBox;
    cbLPT: TComboBox;
    edDrive: TEdit;
    ChkWrite: TCheckBox;
    OpenPort: TButton;
    Aboutinquire: TButton;
    edQuery: TEdit;
    Print: TButton;
    ClosePort: TButton;
    GroupBox3: TGroupBox;
    Label10: TLabel;
    pagewide: TComboBox;
    IP1: TEdit;
    IP2: TEdit;
    IP3: TEdit;
    IP4: TEdit;
    PortChoice: TRadioGroup;
    ModeSelect: TRadioGroup;
    procedure FormResize(Sender: TObject);
    procedure IP4KeyPress(Sender: TObject; var Key: Char);
  //procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure OpenPortClick(Sender: TObject);
    procedure AboutinquireClick(Sender: TObject);
    procedure ClosePortClick(Sender: TObject);
    procedure PrintClick(Sender: TObject);
    procedure IP1KeyPress(Sender: TObject; var Key: Char);
    procedure IP2KeyPress(Sender: TObject; var Key: Char);
    procedure IP3KeyPress(Sender: TObject; var Key: Char);
    procedure PortChoiceClick(Sender: TObject);
    procedure cbPortNameChange(Sender: TObject);
    procedure IP1Change(Sender: TObject);
    procedure IP2Change(Sender: TObject);
    procedure IP3Change(Sender: TObject);
    procedure IP4Change(Sender: TObject);
    procedure cbLPTChange(Sender: TObject);
  private
    { Private declarations }
    procedure PrintInStandardMode80();
    procedure PrintInPageMode80();
    procedure PrintInStandardMode56();
    procedure PrintInPageMode56();
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  b_OpenPort :boolean;//OpenPort.
  Portname,Portname1 : String;///Portname
  baudRate1,StopBit,DataBit,HandShake,Paritytemp :Integer;
  ComName,LptName,UsbName: integer;
  Porttype :integer;
  state:integer;
  
  bHasDownToFlash56: Bool;
  bHasDownToFlash80: Bool;
  bHasDownToRAM56: Bool;
  bHasDownToRAM80: Bool;
  portid:integer;

  i_portIndex : integer;
  ipConst : String;        //Network interface input IP value
  iReturndate : integer;

implementation

{$R *.dfm}

procedure TMainForm.PrintInStandardMode80();   //80 mm standard specimen function mode
var
  strBitImages: string;
  iCount: Integer;
begin
   iReturndate:=POS_SetMotionUnit(180, 180);
  if iReturndate<>1001 then
  begin
     edQuery.Text:='prient Failed!';
     OpenPort.Enabled:=true;
     Aboutinquire.Enabled:=false;
     Print.Enabled:=False;
     ClosePort.Enabled:=False;
     exit;
  end;

  //  Loading bitmap to Flash,If the power down is not lost.

  strBitImages := 'Kitty.bmp@Look.bmp';
  iCount := 2;

  if bHasDownToFlash80 = False then
  begin
    POS_PreDownloadBmpsToFlash(strBitImages, iCount);
    bHasDownToFlash80 := True;
 {   if PortChoice.ItemIndex=1 then
    begin
      Print.Enabled:=False;
    end;
 }
  end;


	POS_SetMode(POS_PRINT_MODE_STANDARD);

	POS_SetRightSpacing(0);

	POS_SetLineSpacing(100);
	POS_S_TextOut('T-40', 50, 2, 3, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_SetLineSpacing(35);

	POS_FeedLine();
	POS_FeedLine();

	POS_S_TextOut('T-40', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_THICK_UNDERLINE);
	POS_FeedLine();
	POS_S_TextOut('T-40', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_THIN_UNDERLINE);
	POS_FeedLine();
	POS_FeedLine();

	POS_SetLineSpacing(24);

	// Character right different spacing

	POS_SetRightSpacing(0);
	POS_S_TextOut('T-40', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_S_TextOut('POS Thermal Printer', 200, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();

	POS_SetRightSpacing(2);
	POS_S_TextOut('T-40', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_S_TextOut('POS Thermal Printer', 200, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();

	POS_SetRightSpacing(4);
	POS_S_TextOut('T-40', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_S_TextOut('POS Thermal Printer', 200, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
	POS_FeedLine();

	// Different character style

	POS_SetRightSpacing(2);
	POS_S_TextOut('Normal font for printing', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
  POS_S_TextOut('Reverse display font for printing', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_REVERSE);
	POS_FeedLine();
	POS_S_TextOut('90 degrees clockwise font for printing', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_CLOCKWISE_90);
	POS_FeedLine();
	POS_S_TextOut('Inverted font for printing', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_UPSIDEDOWN);
	POS_FeedLine();
	POS_FeedLine();
	

	// Barcode printing

	POS_SetRightSpacing(0);

	POS_S_TextOut('----------------------------------', 50, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();

	POS_S_TextOut('Barcode - Code 128', 160, 1, 1, POS_FONT_TYPE_COMPRESSED,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
	POS_FeedLine();

	POS_S_SetBarcode('{A*1234ABCDE*{C5678', 40, POS_BARCODE_TYPE_CODE128,
    2, 50, POS_FONT_TYPE_COMPRESSED, POS_HRI_POSITION_BOTH, 19);
	POS_FeedLine();
	
	POS_S_TextOut('----------------------------------', 50, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);	
	POS_FeedLine();

	// Print the bitmap has been downloaded to the Flash

	POS_FeedLine();
	POS_S_TextOut('-------------> Logo 1', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
	POS_S_PrintBmpInFlash(1, 20, POS_BITMAP_PRINT_NORMAL);

	POS_FeedLine();
	POS_S_TextOut('-------------> Logo 2', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
	POS_S_PrintBmpInFlash(2, 20, POS_BITMAP_PRINT_NORMAL);

	POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();

	// CutPaper
	POS_CutPaper(POS_CUT_MODE_FULL, 0);
  edQuery.Text:='Print Success!';

end;

procedure TMainForm.PrintInPageMode80();     //80 mm standard specimen function mode
begin
   iReturndate:=POS_SetMotionUnit(180, 180);
  if iReturndate<>1001 then
  begin
     edQuery.Text:='Print Fail！';
     OpenPort.Enabled:=true;
     Aboutinquire.Enabled:=false;
     Print.Enabled:=False;
     ClosePort.Enabled:=False;
     exit;
  end;

   // Loading bitmap to RAM,If the power down is lost.
  if bHasDownToRAM80 = False then
  begin
    POS_PreDownloadBmpToRAM('Kitty.bmp', 0);      // ID is 0
		POS_PreDownloadBmpToRAM('Look.bmp', 1);     // ID is 1
   // bHasDownToRAM80 := True;
  end;

  //POS_SetMotionUnit(180, 180);
	POS_SetMode(POS_PRINT_MODE_PAGE);	

	POS_PL_SetArea(10, 10, 620, 800, POS_AREA_BOTTOM_TO_TOP);
	POS_PL_Clear();

	POS_SetRightSpacing(0);

	POS_PL_TextOut('T-40', 20, 80, 2, 2, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_THICK_UNDERLINE);

	// Different character right spacing

	POS_SetRightSpacing(0);
	POS_PL_TextOut('T-40', 30, 140, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_PL_TextOut('POS Thermal Printer', 300, 140, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_SetRightSpacing(4);
	POS_PL_TextOut('T-40', 30, 180, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_PL_TextOut('POS Thermal Printer', 300, 180, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_SetRightSpacing(8);
	POS_PL_TextOut('T-40', 30, 220, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_PL_TextOut('POS Thermal Printer', 300, 220, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_SetRightSpacing(0);

	POS_PL_TextOut('********************', 110, 260, 2, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	// Barcode printing

	POS_PL_TextOut('Barcode - Code 128', 260, 290, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_PL_SetBarcode('{A*123ABC*{C34567890', 40, 360, POS_BARCODE_TYPE_CODE128, 3, 50,
		POS_FONT_TYPE_COMPRESSED, POS_HRI_POSITION_BELOW, 20);

	// Print the bitmap has been downloaded to the RAM

	POS_PL_PrintBmpInRAM(0, 50, 450, POS_BITMAP_PRINT_NORMAL);
	POS_PL_PrintBmpInRAM(0, 230, 450, POS_BITMAP_PRINT_NORMAL);
	POS_PL_PrintBmpInRAM(1, 410, 450, POS_BITMAP_PRINT_NORMAL);
	POS_PL_PrintBmpInRAM(1, 590, 450, POS_BITMAP_PRINT_NORMAL);

	POS_PL_Print();
	POS_PL_Clear();
	POS_CutPaper(POS_CUT_MODE_PARTIAL, 150);
  edQuery.Text:='Print Success!';
{  if PortChoice.ItemIndex=1 then
    begin
      Print.Enabled:=False;
    end;
 }
end;

procedure TMainForm.PrintInStandardMode56();    //56 mm standard specimen function mode
var
  strBitImages: string;
  iCount: Integer;
begin
 iReturndate:=POS_SetMotionUnit(180, 180);
  if iReturndate<>1001 then
  begin
     edQuery.Text:='Failed！';
     OpenPort.Enabled:=true;
     Aboutinquire.Enabled:=false;
     Print.Enabled:=False;
     ClosePort.Enabled:=False;
     exit;
  end;

  // Loading bitmap to Flash,If the power down is not lost.

  strBitImages := 'Kitty.bmp@Look.bmp';
  iCount := 2;

  if bHasDownToFlash56 = False then
  begin
    POS_PreDownloadBmpsToFlash(strBitImages, iCount);
    bHasDownToFlash56 := True;
  end;

  //POS_SetMotionUnit(180, 180);
	POS_SetMode(POS_PRINT_MODE_STANDARD);

	POS_SetRightSpacing(0);

	POS_SetLineSpacing(100);
	POS_S_TextOut('T-40', 30, 1, 2, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_SetLineSpacing(35);

	POS_FeedLine();
	POS_FeedLine();
	POS_S_TextOut('Thermal printer', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_THICK_UNDERLINE);
	POS_FeedLine();
	POS_S_TextOut('Thermal  printer', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_THIN_UNDERLINE);
	POS_FeedLine();
	POS_FeedLine();

  POS_SetLineSpacing(24);

	// Character right different spacing

	POS_SetRightSpacing(0);
	POS_S_TextOut('T-40', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_S_TextOut('POS Printer', 200, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();

	POS_SetRightSpacing(2);
	POS_S_TextOut('T-40', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_S_TextOut('POS Printer', 200, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();

	POS_SetRightSpacing(4);
	POS_S_TextOut('T-40', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_S_TextOut('POS Printer', 200, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
	POS_FeedLine();

	// Different font format

	POS_SetRightSpacing(5);
	POS_S_TextOut('Normal font for printing', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
  POS_S_TextOut('Reverse display font for printing', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_REVERSE);
	POS_FeedLine();
	POS_S_TextOut('90 degrees clockwise font for printing', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_CLOCKWISE_90);
	POS_FeedLine();
	POS_S_TextOut('Inverted font for printing', 20, 1, 1, POS_FONT_TYPE_CHINESE,
		POS_FONT_STYLE_UPSIDEDOWN);
	POS_FeedLine();
	POS_FeedLine();

	// Barcode printing

	POS_SetRightSpacing(0);

	POS_S_TextOut('-----------------------', 50, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_FeedLine();

	POS_S_TextOut('Barcode - Code 128', 100, 1, 1, POS_FONT_TYPE_COMPRESSED,
		POS_FONT_STYLE_NORMAL);

	POS_FeedLine();

	POS_S_SetBarcode('{A*123AB{C567', 50, POS_BARCODE_TYPE_CODE128, 2, 50,
    POS_FONT_TYPE_COMPRESSED, POS_HRI_POSITION_BOTH, 13);

	POS_S_TextOut('-----------------------', 50, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_FeedLine();

	// Print the bitmap has been downloaded to the Flash

	POS_FeedLine();
	POS_S_TextOut('-------------> Logo 1', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
	POS_S_PrintBmpInFlash(1, 20, POS_BITMAP_PRINT_NORMAL);
	POS_FeedLine();

	POS_S_TextOut('-------------> Logo 2', 20, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_FeedLine();
	POS_S_PrintBmpInFlash(2, 20, POS_BITMAP_PRINT_NORMAL);

	POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();
  POS_FeedLine();
	POS_FeedLine();

	// CutPaper
	POS_CutPaper(POS_CUT_MODE_FULL, 0);
  edQuery.Text:='Print Success!';
{  if PortChoice.ItemIndex=1 then
    begin
      Print.Enabled:=False;
    end;

 }
end;

procedure TMainForm.PrintInPageMode56();    //56 mm standard specimen function mode
begin
  iReturndate:=POS_SetMotionUnit(180, 180);
  if iReturndate<>1001 then
    begin
     edQuery.Text:='Print Failed!';
     OpenPort.Enabled:=true;
     Aboutinquire.Enabled:=false;
     Print.Enabled:=False;
     ClosePort.Enabled:=False;
     exit;
    end;

  // Loading bitmap to RAM,If the power down is lost.
  if bHasDownToRAM56 = False then
    begin
      POS_PreDownloadBmpToRAM('Kitty.bmp', 0);      // ID is 0
		  POS_PreDownloadBmpToRAM('Look.bmp', 1);     // ID is 1
    //bHasDownToRAM56 := True;
    end;

  //POS_SetMotionUnit(180, 180);
	POS_SetMode(POS_PRINT_MODE_PAGE);

	POS_PL_SetArea(10, 10, 440, 800, POS_AREA_BOTTOM_TO_TOP);

	POS_PL_Clear();

	POS_SetRightSpacing(0);

	POS_PL_TextOut('POS Thermal Printer', 0, 50, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_THICK_UNDERLINE);

	// Different character right spacing

	POS_SetRightSpacing(0);
	POS_PL_TextOut('T-40', 5, 80, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_PL_TextOut('POS Thermal Printer', 230, 80, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);


	POS_SetRightSpacing(4);
	POS_PL_TextOut('T-40', 5, 110, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_PL_TextOut('POS Thermal Printer', 230, 110, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_SetRightSpacing(8);
	POS_PL_TextOut('T-40', 5, 140, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	POS_PL_TextOut('POS Thermal Printer', 230, 140, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);
	
	POS_SetRightSpacing(0);
	POS_SetLineSpacing(0);

	POS_PL_TextOut('********************', 70, 170, 2, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	// Barcode printing

	POS_PL_TextOut('Barcode - Code 128', 180, 195, 1, 1, POS_FONT_TYPE_STANDARD,
		POS_FONT_STYLE_NORMAL);

	POS_PL_SetBarcode('{A*12345ABC*{C90', 5, 260, POS_BARCODE_TYPE_CODE128, 3, 50,
    POS_FONT_TYPE_COMPRESSED, POS_HRI_POSITION_BELOW, 16);
	
	// Print the bitmap has been downloaded to the RAM

	POS_PL_PrintBmpInRAM(0, 50, 330, POS_BITMAP_PRINT_NORMAL);
//	POS_PL_PrintBmpInRAM(0, 230, 370, POS_BITMAP_PRINT_NORMAL);
	POS_PL_PrintBmpInRAM(1, 410, 330, POS_BITMAP_PRINT_NORMAL);
//	POS_PL_PrintBmpInRAM(1, 590, 370, POS_BITMAP_PRINT_NORMAL);

	POS_PL_Print();

	POS_PL_Clear();

	POS_CutPaper(POS_CUT_MODE_PARTIAL, 150);
  edQuery.Text:='Print Success!';
{  if PortChoice.ItemIndex=1 then
    begin
      Print.Enabled:=False;
    end;

 }
end;
//The function call completion status query function----------------------------
procedure TMainForm.AboutinquireClick(Sender: TObject);
var
  bits: array [0..7] of Integer;
  chStatus: Char;
  i: Integer;
  iReturn: Integer;
  strInfo: string;
begin
  if state <= 0  then
  begin
    edQuery.Text :='The port is not open';
    exit;
  end;
  strInfo := '';
   if PortChoice.ItemIndex=1 then
     iReturn:=POS_NETQueryStatus(PChar(ipConst),@chStatus)
   else
   begin
     iReturn := POS_RTQueryStatus(@chStatus);
   end;
  If iReturn <> POS_SUCCESS Then
  begin
    strInfo := 'Status query failure!';
    edQuery.Text := strInfo;
    OpenPort.Enabled:=true;
    Aboutinquire.Enabled:=false;
    Print.Enabled:=False;
    ClosePort.Enabled:=False;
    exit;
  End;

  If (Integer(chStatus) = 1) then
  begin
   edQuery.Text := 'Everything is normal!';
    exit;
  end;

  for i := 0 to 7 do
  begin
    bits[i] := (Integer(chStatus) shr i) And 1;
  end;

  if bits[0] = 0 then
    strInfo := 'Cash Drawer Opened!';

	if bits[1] = 1 then
    strInfo := strInfo + 'OFFLINE!';

	if bits[2] = 1 then
	  strInfo := strInfo + 'COVER OPEN!';

  if bits[3] = 1 then
    strInfo := Strinfo + 'FEEDING!';

	if bits[4] = 1 then
	  strInfo := strInfo + 'ERROR!';

	if bits[5] = 1 then
	  strInfo := strInfo + 'CUTTER ERROR!';

	if bits[6] = 1 then
	  strInfo := strInfo + 'Paper will end!';

	if bits[7] = 1 then
    strInfo := strInfo + 'Out of Paper';

  if strInfo = '' then
    strInfo := 'Everything is normal!';

  edQuery.Text:= strInfo;
end;
//The function call completion status query function----------------------------
//------------------------------------------------------------------------------
//If change the options will first open ports closed----------------------------
procedure TMainForm.cbLPTChange(Sender: TObject);
begin
    if  state  > 0 then
  begin
    POS_Close();
    state := 0;
  end;
end;

procedure TMainForm.cbPortNameChange(Sender: TObject);
begin
 if  state  > 0 then
  begin
    POS_Close();
    state := 0;
  end;
end;
//If change the options will first open ports closed----------------------------
//******************************************************************************
//Port closure operation--------------------------------------------------------
procedure TMainForm.ClosePortClick(Sender: TObject);
begin
  POS_Close();
  state := 0;
  if state<=0 then
  begin
     edQuery.Text:='Port close Successful!';
     OpenPort.Enabled:=true;
  end;
  if state>0 then
  begin
     edQuery.Text:='Port close failed!';
  end;
  ClosePort.Enabled:=False;
  Aboutinquire.Enabled:=False;
  print.Enabled:=False;
end;


//Port closure operation--------------------------------------------------------
//******************************************************************************
//Calling the version description function, reaction version information--------
procedure TMainForm.FormCreate(Sender: TObject);
var
    m_version,aaa : String;
    X,Y:integer;
    p1,p2:Pinteger;
begin
    p1:=@X;
    p2:=@Y;
    m_version := Format('Everything is normal,version--%d',[POS_GetVersionInfo(@X,@Y)]);
    edQuery.Text :='Everything is normal,version'+IntToStr(X)+'.'+IntToStr(Y);
    cbLPT.Enabled:=False;
    edDrive.Enabled:=False;
    IP1.Enabled:=False;
    IP2.Enabled:=False;
    IP3.Enabled:=False;
    IP4.Enabled:=False;
    ClosePort.Enabled:=False;
    Print.Enabled:=False;
end;
procedure TMainForm.FormResize(Sender: TObject);
begin

end;

//Calling the version description function, reaction version information--------
//******************************************************************************
//Input operation network interface---------------------------------------------
procedure TMainForm.IP1Change(Sender: TObject);
begin
if IP1.Text<>'' then
  begin
    if (StrToInt(IP1.Text)>255)or (StrToInt(IP1.Text)<0) then
    begin
     IP1.Text:='255';
    end;
  end;
end;

procedure TMainForm.IP1KeyPress(Sender: TObject; var Key: Char);
begin
  begin
  //Delete the selected content
    IP1.SetSelTextBuf('');
  //If input‘'.',Then output to move the focus to the next control
  if(Key = '.') then
  begin
    IP2.SetFocus();
    Key :=  #0;
    Exit;
  end;
  if(length(IP1.Text) >= 3) and (Key <> #8) then
  begin
    Key := #0;
    MessageBeep(1);
    exit;
  end;
  if not (Key in ['0'..'9',#8]) then
  begin
    Key := #0;
    MessageBeep(1);
  end;
end;
end;

procedure TMainForm.IP2Change(Sender: TObject);
begin
  if IP2.Text<>'' then
  begin
    if (StrToInt(IP2.Text)>255)or (StrToInt(IP2.Text)<0) then
    begin
     IP2.Text:='255';
    end;
  end;
end;

procedure TMainForm.IP2KeyPress(Sender: TObject; var Key: Char);
begin
  begin
  //Delete the selected content
    IP2.SetSelTextBuf('');
  //If input‘'.',Then output to move the focus to the next control
  if(Key = '.') then
  begin
    IP3.SetFocus();
    Key :=  #0;
    Exit;
  end;
  if(length(IP2.Text) >= 3) and (Key <> #8) then
  begin
    Key := #0;
    MessageBeep(1);
    exit;
  end;
  if not (Key in ['0'..'9',#8]) then
  begin
    Key := #0;
    MessageBeep(1);
  end;
end;

end;
procedure TMainForm.IP3Change(Sender: TObject);
begin
  if IP3.Text<>'' then
  begin
    if (StrToInt(IP3.Text)>255)or (StrToInt(IP3.Text)<0) then
    begin
     IP3.Text:='255';
    end;
  end;
end;

procedure TMainForm.IP3KeyPress(Sender: TObject; var Key: Char);
begin
  begin
  //Delete the selected content
    IP3.SetSelTextBuf('');
  //If input‘'.',Then output to move the focus to the next control
  if(Key = '.') then
  begin
    IP4.SetFocus();
    Key :=  #0;
    Exit;
  end;
  if(length(IP3.Text) >= 3) and (Key <> #8) then
  begin
    Key := #0;
    MessageBeep(1);
    exit;
  end;
  if not (Key in ['0'..'9',#8]) then
  begin
    Key := #0;
    MessageBeep(1);
  end;
end;
end;
procedure TMainForm.IP4Change(Sender: TObject);
begin
  if IP4.Text<>'' then
  begin
    if (StrToInt(IP4.Text)>255)or (StrToInt(IP4.Text)<0) then
    begin
     IP4.Text:='255';
    end;
  end;
end;

procedure TMainForm.IP4KeyPress(Sender: TObject; var Key: Char);
begin
  begin
  //Delete the selected content
    IP4.SetSelTextBuf('');
  //If input‘'.',Then output to move the focus to the next control
  if(Key = '.') then
  begin
    ChkWrite.SetFocus();
    Key :=  #0;
    Exit;
  end;
  if(length(IP4.Text) >= 3) and (Key <> #8) then
  begin
    Key := #0;
    MessageBeep(1);
    exit;
  end;
  if not (Key in ['0'..'9',#8]) then
  begin
    Key := #0;
    MessageBeep(1);
  end;
end;

end;

//Input operation network interface---------------------------------------------
//******************************************************************************
//Open the port operation process to open all the port function call process----
procedure TMainForm.OpenPortClick(Sender: TObject);
var
  baudrate:integer;        //Baudrate
  portName : pchar;        //PortName
  i_DriverData : pchar;   //The addition of driving
  I_cbData  : integer;    //A variable data
begin
  if state > 0 then
  begin
    POS_Close();
    state := 0;
    ClosePort.Enabled:=False;
  end;
  if i_portIndex = 0 then          //COM Operation
  begin
//The parameters of COM  are set to true
// The other port parameters set to false
    case cbPortName.ItemIndex of
      0: portName := 'COM1';
      1: portName := 'COM2';
      2: portName := 'COM3';
      3: portName := 'COM4';
      4: portName := 'COM5';
      5: portName := 'COM6';
      6: portName := 'COM7';
      7: portName := 'COM8';
      8: portName := 'COM9';
      9: portName := 'COM10';
    end;
    case cbBaud.ItemIndex of
      0: baudrate := 2400;
      1: baudrate := 4800;
      2: baudrate := 9600;
      3: baudrate := 19200;
      4: baudrate := 38400;
      5: baudrate := 57600;
      6: baudrate := 115200;
    end;
    case cbData.ItemIndex of
      0: I_cbData:=7;
      1: I_cbData:=8;
    end;
    state := POS_Open(portName, baudrate, I_cbData, POS_COM_ONESTOPBIT, cbParity.ItemIndex, cbFlow.ItemIndex);
//Judge the port open or not----------------------------------------------------
   { if state <> -1 then
    begin
      Print.Enabled := true;
      edQuery.Text := 'Port open success';
    end
    else
     begin
      Print.Enabled := true;
      edQuery.Text := 'Port open failed';
    end }
//Judge the port open or not----------------------------------------------------
  end
  else if i_portIndex = 1 then  //The network interface operation input IP to determine their own needs operation
  begin
    edQuery.Text:='Select the network port';
    ipConst:=(IP1.Text+'.'+IP2.Text+'.'+IP3.Text+'.'+IP4.Text);
    if (IP1.Text='')or (IP2.Text='')or (IP3.Text='') or (IP4.Text='') then
  begin
    edQuery.Text:='IP Can not be empty';
    exit;
  end;
    state := POS_Open(PChar(ipConst),0,0,0,0,$15);
  end
  else if i_portIndex =2  then  //LPT operation,Here listed only two LPT can be added according to need
  begin
     case cbLPT.ItemIndex of
       0:  portName:='LPT1';
       1:  portName:='LPT2';
     end;
    state := POS_Open(portName,0, 0,0,0,$12);
  end
  else if i_portIndex = 3 then  //Drive the operation of manual input installed printer drivers
  begin
  if edDrive.Text='' then
  begin
    edQuery.text:='The driver nameCan not be empty!';
    exit;
  end;
    i_DriverData:=PAnsiChar(edDrive.Text);
  //state := POS_Open('BTP-2002CP(S)',0,0,0,0,$14); //A default printer driver to operate at that time
    state := POS_Open(i_DriverData,0,0,0,0,$14);    //The input drive must already exist the printer
  end
  else
  begin
    state := POS_Open('BYUSB-0', 0, 0, 0, 0, $13);  //USB operation
  end;

//Judge the port open or not----------------------------------------------------
   if state <> -1 then
    begin
      Print.Enabled := true;
      edQuery.Text := 'Port open success!';
      OpenPort.Enabled:=False;
      ClosePort.Enabled:=True;
      if i_portIndex =2 then
      begin
         Aboutinquire.Enabled:=False;
      end;
      if i_portIndex <>2 then
      begin
        Aboutinquire.Enabled:=true;
      end;
      Print.Enabled:=True;
      ClosePort.Enabled:=True;
    end
    else
     begin
      Print.Enabled := true;
      edQuery.Text := 'Port open failed!';
      Aboutinquire.Enabled:=False;
      Print.Enabled:=False;
      ClosePort.Enabled:=False;
    end;
//Judge the port open or not----------------------------------------------------

end;
//According to different choices to display,According to different choices of the interface to display
procedure TMainForm.PortChoiceClick(Sender: TObject);
begin
  if  state  > 0 then
  begin
    POS_Close();
    state := 0;
    OpenPort.Enabled:=true;
    ClosePort.Enabled:=False;
    Print.Enabled:=False;
    Aboutinquire.Enabled:=False;
  end;
  i_portIndex :=  PortChoice.ItemIndex;
  if i_portIndex = 0 then
  begin
    cbLPT.Enabled:=False;
    edDrive.Enabled:=False;
    IP1.Enabled:=False;
    IP2.Enabled:=False;
    IP3.Enabled:=False;
    IP4.Enabled:=False;
    cbPortName.Enabled:=true;
    cbData.Enabled:=true;
    cbBaud.Enabled:=True;
    cbStop.Enabled:=true;
    cbParity.Enabled:=true;
    cbFlow.Enabled:=True;
    edQuery.Text:='Selection COM';
    //The parameters of COM  are set to true
    //The other port parameters set to false
  end
  else if i_portIndex = 1 then
  begin
    cbLPT.Enabled:=False;
    edDrive.Enabled:=False;
    IP1.Enabled:=true;
    IP2.Enabled:=true;
    IP3.Enabled:=true;
    IP4.Enabled:=true;
    cbPortName.Enabled:=False;
    cbData.Enabled:=False;
    cbBaud.Enabled:=False;
    cbStop.Enabled:=False;
    cbParity.Enabled:=False;
    cbFlow.Enabled:=False;
   edQuery.Text:='Selection the network interface';
  end
  else if i_portIndex =2  then
  begin
    edQuery.Text:='Selection LPT';
    cbLPT.Enabled:=True;
    edDrive.Enabled:=False;
    IP1.Enabled:=False;
    IP2.Enabled:=False;
    IP3.Enabled:=False;
    IP4.Enabled:=False;
    cbPortName.Enabled:=False;
    cbData.Enabled:=False;
    cbBaud.Enabled:=False;
    cbStop.Enabled:=False;
    cbParity.Enabled:=False;
    cbFlow.Enabled:=False;
  end
  else if i_portIndex = 3 then
  begin
    edQuery.Text:='Selection the driver';
    cbLPT.Enabled:=False;
    edDrive.Enabled:=True;
    IP1.Enabled:=False;
    IP2.Enabled:=False;
    IP3.Enabled:=False;
    IP4.Enabled:=False;
    cbPortName.Enabled:=False;
    cbData.Enabled:=False;
    cbBaud.Enabled:=False;
    cbStop.Enabled:=False;
    cbParity.Enabled:=False;
    cbFlow.Enabled:=False;
  end
  else
  begin
    edQuery.Text:='Selection USB';
    cbLPT.Enabled:=False;
    edDrive.Enabled:=False;
    IP1.Enabled:=False;
    IP2.Enabled:=False;
    IP3.Enabled:=False;
    IP4.Enabled:=False;
    cbPortName.Enabled:=False;
    cbData.Enabled:=False;
    cbBaud.Enabled:=False;
    cbStop.Enabled:=False;
    cbParity.Enabled:=False;
    cbFlow.Enabled:=False;
  end;
end;
//According to different choices to display,According to different choices of the interface to display
//******************************************************************************
//The specific operation of printing--------------------------------------------
procedure TMainForm.PrintClick(Sender: TObject);
var
    printwidth: integer;
    printtype :integer;
    //In the driving variables----------------------------
    {DocInfo:DOC_INFO_1;
    hport : Thandle;
    i: Integer;
    buf : array[1..50] of char;
    dwBytesWritten :DWORD;     }
    //In the driving variables-----------------------------
begin
    if ChkWrite.Checked  then
      begin
       POS_BeginSaveFile(PAnsiChar(ExtractFilePath(paramstr(0))+'Test.txt'),false);
      end;
    printtype := ModeSelect.ItemIndex;
    printwidth := pagewide.ItemIndex;
    if i_portIndex =  3 then
      begin
        POS_StartDoc();
      end;
    if printtype = 0 then
      begin
        if printwidth = 0 then
          PrintInStandardMode80()
        else   PrintInStandardMode56();
      end
    else
    begin
      if printwidth = 0 then
         PrintInPageMode80()
      else
         PrintInPageMode56();
    end;
   if i_portIndex=3 then
      begin
         if POS_EndDoc()=true then
          begin
            edQuery.Text:='Print Success!';
          end;
   {if ChkWrite.Checked  then
      begin
        POS_EndSaveFile();
      end;    }
  end;
	 { DocInfo.pDocName := 'My Document';
    DocInfo.pOutputFile := nil;
    DocInfo.pDatatype := 'RAW';
    OpenPrinter('BTP-2002CP(S)',hport,Nil);
    StartDocPrinter(hPort, 1, @DocInfo);
    for i := 1 to 50 do
    begin
      buf[i] := #$32;
    end;
    buf[50] := #$0a;
    dwBytesWritten := 0;
    WritePrinter(hPort,@buf,50,dwBytesWritten);
    EndDocPrinter(hPort);
   end; } //Here for the pass issued instructions to make the printer by driving the print out the necessary proofs

end;

end.
//The specific operation of printing--------------------------------------------
